/****** Object:  StoredProcedure [dbo].[P_GERA_VLR_PRECO_OPERADOR_LOG]    Script Date: 08/16/2012 18:36:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_VLR_PRECO_OPERADOR_LOG]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_VLR_PRECO_OPERADOR_LOG]
GO
 
    

CREATE PROCEDURE [dbo].[P_GERA_VLR_PRECO_OPERADOR_LOG] (@CD_EMP INT=1 )
AS


DECLARE @CD_PROD		AS INT 
DECLARE @FLAG_SUBS		AS SMALLINT
DECLARE @VLR_REF		AS MONEY
DECLARE @TP_PRECO		AS SMALLINT 
DECLARE @VLR_PRECO_OPERADOR_LOG	AS MONEY 
DECLARE @CD_FILIAL		AS INT
DECLARE @CD_CTR_DEPO	AS INT
DECLARE @MARGEM			AS MONEY
DECLARE @PERC_SEM_ST	AS MONEY
DECLARE @PERC_ST		AS MONEY
DECLARE @TIPO_AGREGAR	AS MONEY


BEGIN 
		
		SET @CD_FILIAL= (SELECT TOP 1  CD_FILIAL FROM PRC_FILIAL WHERE CD_EMP = @CD_EMP AND FLAG_OPERADOR_LOG = 1);
		SET @CD_CTR_DEPO = (SELECT TOP 1  CD_CTR_DEPO FROM PRC_FILIAL_DEPOSITO WHERE CD_FILIAL= @CD_FILIAL);
		
		DECLARE cProd CURSOR FAST_FORWARD READ_ONLY FOR 
		SELECT 
			CD_PROD
		FROM 
			EST_PROD
		WHERE 
			CD_EMP = 1 
		ORDER BY CD_PROD
			
		OPEN cProd
		FETCH NEXT FROM cProd INTO @CD_PROD 
		WHILE @@FETCH_STATUS=0
		
			BEGIN

/*************************************************************************************************************************************************/				
/**				CARREGAS AS VARIAVEIS																											**/
/*************************************************************************************************************************************************/				

				SET @FLAG_SUBS = ISNULL((SELECT     
												EST_PROD_CPL_TRIB_EST.CD_TRIB
											FROM         
												EST_PROD_CPL_TRIB_EST INNER JOIN EST_TRIB ON 
												EST_PROD_CPL_TRIB_EST.CD_TRIB = EST_TRIB.CD_TRIB
											WHERE     
												EST_PROD_CPL_TRIB_EST.CD_EMP = @CD_EMP 
												AND EST_PROD_CPL_TRIB_EST.CD_FILIAL = @CD_FILIAL
												AND EST_PROD_CPL_TRIB_EST.TP_MOV = 0 
												AND EST_PROD_CPL_TRIB_EST.TP_TRANSA = 1 
												AND EST_TRIB.SUBS_TRIB = 1 
												AND EST_PROD_CPL_TRIB_EST.CD_PROD = @CD_PROD),0)
											
					SELECT 
						@TP_PRECO		= TP_PRECO,
						@PERC_ST		= PERC_ST,
						@PERC_SEM_ST	= PERC_SEM_ST,
						@TIPO_AGREGAR	= TIPO
					FROM 
						GLB_CONFIG_PRECO_OPERADOR_LOG	
					WHERE
						CD_ARV_MERC_LINHA = (SELECT TOP 1
												CD_ARV_MERC_LINHA 
											FROM 
												EST_PROD_EST_ARV_MERCADOLOGICA												
											WHERE
												CD_EMP = @CD_EMP 
												AND CD_PROD = @CD_PROD)
				
				
				IF @TP_PRECO IS NULL
				BEGIN
				 	SET  @TP_PRECO = 4 
				END	
				
/*************************************************************************************************************************************************/				
/**				BUSCA PRECO REFERENCIA																											**/
/*************************************************************************************************************************************************/				

				/*  TIPO DE PRECO

				0 - PREO DE VENDAS
				1 - PREO DE CUSTO
				2 - PREO DE COMPRA
				3 - PREO DE FABRICA
				4 - PREO DE CUSTO MDIO
				5 - PREO DE COMPRA GRUPO				
				*/

				SET @VLR_REF = 0;
				
				--Preco de venda
				IF @TP_PRECO = 0
				BEGIN 
					SET @VLR_REF = ISNULL ((SELECT VLR_TABELA
												FROM         
													EST_PROD_PRECO  C
												WHERE     
													C.CD_EMP = @CD_EMP 
													AND C.CD_FILIAL = @CD_FILIAL
													AND C.CD_PROD = @CD_PROD),0)
				END
				
				--Preco custo / custo medio
				IF @TP_PRECO IN (1,2,4)
				BEGIN 
					SET @VLR_REF = ISNULL ((SELECT  CASE WHEN	@TP_PRECO=1 THEN VLR_CUSTO
														  WHEN	@TP_PRECO=2 THEN VLR_COMPRA 
														  ELSE VLR_CUSTO_MD END
												FROM         
													EST_PROD_CPL c
												WHERE     
													C.CD_EMP = @CD_EMP 
													AND C.CD_FILIAL = @CD_FILIAL				
													AND C.CD_PROD = @CD_PROD),0)
				END

				--Preco fabricca
				IF @TP_PRECO = 3
				BEGIN 
					SET @VLR_REF = ISNULL((SELECT VLR_FORN
												FROM         
													EST_PROD_PRECO_TBL c
													INNER JOIN EST_PROD_PRECO_TBL_GRUPO_PRC_FILIAL F ON 
													C.CD_CTR_GRP = F.CD_CTR_GRP 
												WHERE     
													C.CD_EMP = @CD_EMP
													AND F.CD_FILIAL = @CD_FILIAL
													AND C.CD_PROD	= @CD_PROD),0)
				END

				--Preco de compra grupo
				IF @TP_PRECO = 5
				BEGIN 
					SET @VLR_REF = ISNULL ((SELECT CASE WHEN ISNULL(C.VLR_COMPRA_GRP,0) > 0 THEN 
																C.VLR_COMPRA_GRP
														  ELSE C.VLR_CUSTO_GRP END
													FROM         
														EST_PROD C
													WHERE     
														C.CD_EMP = 1  
														AND C.CD_PROD = @CD_PROD),0)
				END

/*************************************************************************************************************************************************/				
/**				MONTA O VALOR OPERADOR LOGISTICO																								**/
/*************************************************************************************************************************************************/				
			
				
				IF @FLAG_SUBS = 0
					BEGIN
						SET @MARGEM = @PERC_SEM_ST
					END
				ELSE
					BEGIN
						SET @MARGEM = @PERC_ST
					END
					
				IF @TIPO_AGREGAR = 0 
					BEGIN
						SET @MARGEM = 1 +(@MARGEM/100.0000)  
					END
				ELSE
					BEGIN
						SET @MARGEM = 1 -(@MARGEM/100.0000)  
					END
  
					
				SET @VLR_REF = @VLR_REF * @MARGEM
				
				/*************************************/
				SET @VLR_PRECO_OPERADOR_LOG = @VLR_REF 
				/*************************************/														

/*************************************************************************************************************************************************/				
/**				APLICA O VALOR OPERADOR LOGISTICO NO PRODUTO																								**/ 
/*************************************************************************************************************************************************/				

				UPDATE EST_PROD
				SET  
					VLR_PRECO_OPERADOR_LOG = @VLR_PRECO_OPERADOR_LOG
				WHERE 
					CD_EMP = 1
					AND CD_PROD = @CD_PROD
					AND VLR_PRECO_OPERADOR_LOG <> @VLR_PRECO_OPERADOR_LOG;

				UPDATE EST_PROD_CPL
				SET  
					VLR_RESSUP = @VLR_PRECO_OPERADOR_LOG
				WHERE 
					CD_EMP = @CD_EMP
					AND CD_PROD = @CD_FILIAL
					AND CD_PROD = @CD_PROD
					AND VLR_RESSUP <> @VLR_PRECO_OPERADOR_LOG;

				PRINT 'ATUALIZOU O PRODUTO '  + CONVERT(VARCHAR(12), @CD_PROD);
				FETCH NEXT FROM cProd INTO @CD_PROD 
			END
	END

GO


